/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RoilingTerrainEffect
extends OneShotEffect {
    RoilingTerrainEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Destroy target land, then {this} deals damage to that land's controller equal to the number of land cards in that player's graveyard";
    }

    private RoilingTerrainEffect(RoilingTerrainEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoilingTerrainEffect copy() {
        return new RoilingTerrainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetedLand = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetedLand != null) {
            targetedLand.destroy(source, game, true);
            Player targetController = game.getPlayer(targetedLand.getControllerId());
            if (targetController != null) {
                int landsInGraveyard = targetController.getGraveyard().count((FilterCard)new FilterLandCard(), game);
                targetController.damage(landsInGraveyard, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

