/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public final class RootGreevil
extends CardImpl {
    public RootGreevil(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{3}{G}");
        this.subtype.add((Object)SubType.BEAST);
        this.power = new MageInt(2);
        this.toughness = new MageInt(3);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new RootGreevilEffect(), (Cost)new ManaCostsImpl("{2}{G}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        this.addAbility((Ability)ability);
    }

    private RootGreevil(RootGreevil card) {
        super((CardImpl)card);
    }

    public RootGreevil copy() {
        return new RootGreevil(this);
    }

    static class RootGreevilEffect
    extends OneShotEffect {
        public RootGreevilEffect() {
            super(Outcome.DestroyPermanent);
            this.staticText = "Destroy all enchantments of the color of your choice";
        }

        private RootGreevilEffect(RootGreevilEffect effect) {
            super((OneShotEffect)effect);
        }

        public RootGreevilEffect copy() {
            return new RootGreevilEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player controller = game.getPlayer(source.getControllerId());
            ChoiceColor choice = new ChoiceColor();
            if (controller != null && controller.choose(Outcome.DestroyPermanent, (Choice)choice, game)) {
                FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent();
                filter.add((Predicate)new ColorPredicate(choice.getColor()));
                for (Permanent enchantment : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                    enchantment.destroy(source, game, false);
                }
                return true;
            }
            return false;
        }
    }
}

