/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.r.RootingMolochMayPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RootingMolochEffect
extends OneShotEffect {
    RootingMolochEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card with a cycling ability from your graveyard. Until the end of your next turn, you may play that card.";
    }

    private RootingMolochEffect(RootingMolochEffect effect) {
        super((OneShotEffect)effect);
    }

    public RootingMolochEffect copy() {
        return new RootingMolochEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        RootingMolochMayPlayEffect effect = new RootingMolochMayPlayEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(card, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

