/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RootpathPurifierEffect
extends ContinuousEffectImpl {
    RootpathPurifierEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "lands you control and land cards in your library are basic";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private RootpathPurifierEffect(RootpathPurifierEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public RootpathPurifierEffect copy() {
        return new RootpathPurifierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game)) {
            permanent.addSuperType(game, SuperType.BASIC);
        }
        for (Card card : player.getLibrary().getCards(game)) {
            if (!card.isLand(game)) continue;
            card.addSuperType(game, SuperType.BASIC);
        }
        return true;
    }
}

