/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class RootsOfWisdomEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("land card or Elf card");

    RootsOfWisdomEffect() {
        super(Outcome.Benefit);
        this.staticText = "Mill three cards, then return a land card or Elf card from your graveyard to your hand. If you can't, draw a card.";
    }

    private RootsOfWisdomEffect(RootsOfWisdomEffect effect) {
        super((OneShotEffect)effect);
    }

    public RootsOfWisdomEffect copy() {
        return new RootsOfWisdomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(3, source, game);
        TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard(filter);
        targetCard.withNotTarget(true);
        if (targetCard.canChoose(source.getControllerId(), source, game) && player.choose(this.outcome, (Target)targetCard, source, game) && (card = player.getGraveyard().get(targetCard.getFirstTarget(), game)) != null && player.moveCards(card, Zone.HAND, source, game)) {
            return true;
        }
        player.drawCards(1, source, game);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.LAND.getPredicate(), (Predicate)SubType.ELF.getPredicate()));
    }
}

