/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import java.util.Optional;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.GolemXXToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class RootwireAmalgamEffect
extends OneShotEffect {
    RootwireAmalgamEffect() {
        super(Outcome.Benefit);
        this.staticText = "create an X/X colorless Golem artifact creature token, where X is three times {this}'s power. It gains haste until end of turn";
    }

    private RootwireAmalgamEffect(RootwireAmalgamEffect effect) {
        super((OneShotEffect)effect);
    }

    public RootwireAmalgamEffect copy() {
        return new RootwireAmalgamEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = 3 * Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(MageObject::getPower).map(MageInt::getValue).orElse(0);
        GolemXXToken token = new GolemXXToken(xValue);
        token.putOntoBattlefield(1, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        return true;
    }
}

