/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RottenmouthViperEffect
extends OneShotEffect {
    DynamicValue blightCounterAmount;

    RottenmouthViperEffect(DynamicValue blightCounterAmount) {
        super(Outcome.LoseLife);
        this.blightCounterAmount = blightCounterAmount;
        this.staticText = "Then for each blight counter on it, each opponent loses 4 life unless that player sacrifices a nonland permanent of their choice or discards a card.";
    }

    private RottenmouthViperEffect(RottenmouthViperEffect effect) {
        super((OneShotEffect)effect);
        this.blightCounterAmount = effect.blightCounterAmount.copy();
    }

    public RottenmouthViperEffect copy() {
        return new RottenmouthViperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int repeat = this.blightCounterAmount.calculate(game, source, (Effect)this);
            for (int i = 1; i <= repeat; ++i) {
                for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                    Player opponent = game.getPlayer(opponentId);
                    if (opponent == null) continue;
                    Outcome aiOutcome = opponent.getLife() > 10 ? Outcome.Detriment : Outcome.Benefit;
                    int permanents = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, opponentId, game);
                    if (permanents > 0 && opponent.chooseUse(aiOutcome, "Sacrifices a nonland permanent? (Iteration " + i + " of " + repeat + ")", "Otherwise you have to discard a card or lose 4 life.", "Sacrifice", "Discard or life loss", source, game)) {
                        Permanent permanent;
                        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND);
                        target.withNotTarget(true);
                        if (opponent.choose(Outcome.Sacrifice, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && permanent.sacrifice(source, game)) continue;
                    }
                    if (!opponent.getHand().isEmpty() && opponent.chooseUse(aiOutcome, "Discard a card? (Iteration " + i + " of " + repeat + ")", "Otherwise you lose 4 life.", "Discard", "Lose 4 life", source, game)) {
                        opponent.discardOne(false, false, source, game);
                        continue;
                    }
                    opponent.loseLife(4, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

