/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RowanKenrithAttackEffect
extends RequirementEffect {
    RowanKenrithAttackEffect() {
        super(Duration.Custom);
        this.staticText = "During target player's next turn, each creature that player controls attacks if able";
    }

    private RowanKenrithAttackEffect(RowanKenrithAttackEffect effect) {
        super((RequirementEffect)effect);
    }

    public RowanKenrithAttackEffect copy() {
        return new RowanKenrithAttackEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(source.getFirstTarget()) && game.isActivePlayer(source.getFirstTarget());
    }

    public boolean isInactive(Ability source, Game game) {
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game);
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

