/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RowdyCrewEffect
extends OneShotEffect {
    RowdyCrewEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw three cards, then discard two cards at random. If two cards that share a card type are discarded this way, put two +1/+1 counters on {this}";
    }

    private RowdyCrewEffect(RowdyCrewEffect effect) {
        super((OneShotEffect)effect);
    }

    public RowdyCrewEffect copy() {
        return new RowdyCrewEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(3, source, game);
            CardsImpl cards = new CardsImpl();
            int cardsInHand = player.getHand().size();
            switch (cardsInHand) {
                case 0: {
                    break;
                }
                case 1: {
                    player.discard(1, true, false, source, game);
                    break;
                }
                default: {
                    cards = player.discard(2, true, false, source, game);
                }
            }
            if (creature != null && cardsInHand > 1) {
                for (CardType type : CardType.values()) {
                    int count = 0;
                    for (UUID cardId : cards) {
                        if (!game.getCard(cardId).getCardType(game).contains(type) || ++count <= 1) continue;
                        creature.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
                        return true;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

