/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class RuinousIntrusionEffect
extends OneShotEffect {
    RuinousIntrusionEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target artifact or enchantment. Put X +1/+1 counters on target creature you control, where X is the mana value of the permanent exiled this way";
    }

    private RuinousIntrusionEffect(RuinousIntrusionEffect effect) {
        super((OneShotEffect)effect);
    }

    public RuinousIntrusionEffect copy() {
        return new RuinousIntrusionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        int mv = permanent.getManaValue();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (mv < 1) {
            return true;
        }
        Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(mv), source, game);
        }
        return true;
    }
}

