/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class RuneforgeChampionEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("Rune spells");
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Cost)new ManaCostsImpl("{1}"), (Condition)SourceIsSpellCondition.instance, null, filter, true);

    RuneforgeChampionEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Detriment);
        this.staticText = "You may pay {1} rather than pay the mana cost for Rune spells you cast";
    }

    private RuneforgeChampionEffect(RuneforgeChampionEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public RuneforgeChampionEffect copy() {
        return new RuneforgeChampionEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    static {
        filter.add((Predicate)SubType.RUNE.getPredicate());
    }
}

