/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;

class RushedRebirthEffect
extends OneShotEffect {
    RushedRebirthEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "search your library for a creature card with lesser mana value, put it onto the battlefield tapped, then shuffle";
    }

    private RushedRebirthEffect(RushedRebirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public RushedRebirthEffect copy() {
        return new RushedRebirthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card with lesser mana value than " + permanent.getIdName());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, permanent.getManaValue()));
        return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary((FilterCard)filter), true).apply(game, source);
    }
}

