/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.Elemental44Token;
import mage.players.Player;

class WillScholarOfFrostEffect
extends OneShotEffect {
    WillScholarOfFrostEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to five target permanents. For each permanent exiled this way, its controller creates a 4/4 blue and red Elemental creature token";
    }

    private WillScholarOfFrostEffect(WillScholarOfFrostEffect effect) {
        super((OneShotEffect)effect);
    }

    public WillScholarOfFrostEffect copy() {
        return new WillScholarOfFrostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        Map playerMap = cards.getCards(game).stream().filter(Objects::nonNull).map(MageItem::getId).map(arg_0 -> ((Game)game).getControllerId(arg_0)).filter(Objects::nonNull).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Map.Entry entry : playerMap.entrySet()) {
            new Elemental44Token().putOntoBattlefield(entry.getValue().intValue(), game, source, (UUID)entry.getKey());
        }
        return true;
    }
}

