/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.GreenManaAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BecomesColorlessForestLandEffect
extends ContinuousEffectImpl {
    BecomesColorlessForestLandEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Enchanted permanent is a colorless Forest land";
        this.dependencyTypes.add(DependencyType.BecomeNonbasicLand);
        this.dependencyTypes.add(DependencyType.BecomeForest);
    }

    private BecomesColorlessForestLandEffect(BecomesColorlessForestLandEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public BecomesColorlessForestLandEffect copy() {
        return new BecomesColorlessForestLandEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case ColorChangingEffects_5: {
                permanent.getColor(game).setWhite(false);
                permanent.getColor(game).setGreen(false);
                permanent.getColor(game).setBlack(false);
                permanent.getColor(game).setBlue(false);
                permanent.getColor(game).setRed(false);
                break;
            }
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.LAND});
                permanent.removeAllSubTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.FOREST});
                permanent.removeAllAbilities(source.getSourceId(), game);
                permanent.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

