/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CantActivateAbilitiesAttachedEffect
extends RestrictionEffect {
    CantActivateAbilitiesAttachedEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Enchanted creature's activated abilities can't be activated";
    }

    private CantActivateAbilitiesAttachedEffect(CantActivateAbilitiesAttachedEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null && enchantment.getAttachedTo() != null) {
            return permanent.getId().equals(enchantment.getAttachedTo());
        }
        return false;
    }

    public boolean canUseActivatedAbilities(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public CantActivateAbilitiesAttachedEffect copy() {
        return new CantActivateAbilitiesAttachedEffect(this);
    }
}

