/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CantBeBlockedByCreaturesWithFlyingAttachedEffect
extends RestrictionEffect {
    CantBeBlockedByCreaturesWithFlyingAttachedEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Equipped creature can't be blocked by creatures with flying";
    }

    private CantBeBlockedByCreaturesWithFlyingAttachedEffect(CantBeBlockedByCreaturesWithFlyingAttachedEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return game.getPermanent(source.getSourceId()) != null && permanent.getAttachments().contains(source.getSourceId());
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return !blocker.getAbilities().contains((Ability)FlyingAbility.getInstance());
    }

    public CantBeBlockedByCreaturesWithFlyingAttachedEffect copy() {
        return new CantBeBlockedByCreaturesWithFlyingAttachedEffect(this);
    }
}

