/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.game.Game;
import mage.players.Player;
import mage.util.ManaUtil;

class DynamicValueGenericManaCost
extends CostImpl {
    DynamicValue amount;

    public DynamicValueGenericManaCost(DynamicValue amount) {
        this.amount = amount;
        this.setText();
    }

    private DynamicValueGenericManaCost(DynamicValueGenericManaCost cost) {
        super((CostImpl)cost);
        this.amount = cost.amount;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        ManaCost cost = ManaUtil.createManaCost((DynamicValue)this.amount, (Game)game, (Ability)ability, null);
        return cost.canPay(ability, source, controllerId, game);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        ManaCost cost = ManaUtil.createManaCost((DynamicValue)this.amount, (Game)game, (Ability)ability, null);
        this.paid = cost.pay(ability, game, source, controllerId, noMana);
        return this.paid;
    }

    public DynamicValueGenericManaCost copy() {
        return new DynamicValueGenericManaCost(this);
    }

    private void setText() {
        this.text = "Pay {1} for each +1/+1 counter on {this}";
    }
}

