/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MayRemoveM1M1CouterTargetEffect
extends OneShotEffect {
    MayRemoveM1M1CouterTargetEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "You may remove a -1/-1 counter from it.";
    }

    private MayRemoveM1M1CouterTargetEffect(MayRemoveM1M1CouterTargetEffect effect) {
        super((OneShotEffect)effect);
        this.staticText = "You may remove a -1/-1 counter from it.";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent target = game.getPermanent(source.getTargets().getFirstTarget());
        if (target == null) {
            return false;
        }
        if (target.getCounters(game).getCount(CounterType.M1M1) > 0 && controller.chooseUse(this.outcome, "Remove a -1/-1 counter from " + target.getIdName() + "?", source, game)) {
            RemoveCounterTargetEffect effect = new RemoveCounterTargetEffect(CounterType.M1M1.createInstance());
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
            effect.apply(game, source);
        }
        return true;
    }

    public MayRemoveM1M1CouterTargetEffect copy() {
        return new MayRemoveM1M1CouterTargetEffect(this);
    }
}

