/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SacredGroundTriggeredAbility
extends TriggeredAbilityImpl {
    SacredGroundTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SacredGroundTriggeredAbility(SacredGroundTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SacredGroundTriggeredAbility copy() {
        return new SacredGroundTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent targetPermanent;
        ZoneChangeEvent zce;
        if (game.getOpponents(this.getControllerId()).contains(game.getControllerId(event.getSourceId())) && (zce = (ZoneChangeEvent)event).isDiesEvent() && (targetPermanent = zce.getTarget()).isLand(game) && targetPermanent.isOwnedBy(this.getControllerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a spell or ability an opponent controls causes a land to be put into your graveyard from the battlefield, return that card to the battlefield.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

