/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SacredRitesEffect
extends OneShotEffect {
    SacredRitesEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Discard any number of cards. Creatures you control get +0/+1 until end of turn for each card discarded this way.";
    }

    private SacredRitesEffect(SacredRitesEffect effect) {
        super((OneShotEffect)effect);
    }

    public SacredRitesEffect copy() {
        return new SacredRitesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int numDiscarded = controller.discard(0, Integer.MAX_VALUE, false, source, game).size();
        if (numDiscarded > 0) {
            game.addEffect((ContinuousEffect)new BoostControlledEffect(0, numDiscarded, Duration.EndOfTurn), source);
        }
        return true;
    }
}

