/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SageEyeAvengersEffect
extends OneShotEffect {
    SageEyeAvengersEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "you may return target creature to its owner's hand if its power is less than {this}'s power";
    }

    private SageEyeAvengersEffect(SageEyeAvengersEffect effect) {
        super((OneShotEffect)effect);
    }

    public SageEyeAvengersEffect copy() {
        return new SageEyeAvengersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null && targetCreature.getPower().getValue() < sourceObject.getPower().getValue()) {
                controller.moveCards((Card)targetCreature, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

