/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class SailIntoTheWestEffect
extends OneShotEffect {
    SailIntoTheWestEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for return or embark. If return gets more votes, each player returns up to two cards from their graveyard to their hand, then you exile {this}. If embark gets more votes or the vote is tied, each player may discard their hand and draw seven cards.";
    }

    private SailIntoTheWestEffect(SailIntoTheWestEffect effect) {
        super((OneShotEffect)effect);
    }

    public SailIntoTheWestEffect copy() {
        return new SailIntoTheWestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Return (return up to 2 cards from graveyard)", "Embark (may discard all and draw 7)", Outcome.Benefit);
        vote.doVotes(source, game);
        int returnCount = vote.getVoteCount((Object)true);
        int embarkCount = vote.getVoteCount((Object)false);
        if (returnCount > embarkCount) {
            return this.applyReturn(game, source);
        }
        return this.applyEmbark(game, source);
    }

    private boolean applyReturn(Game game, Ability source) {
        game.informPlayers("'Return' won the vote. Each player may return up to two cards from their graveyard to their hand");
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            FilterCard filter = new FilterCard("card from your graveyard");
            filter.add((Predicate)new OwnerIdPredicate(player.getId()));
            TargetCardInGraveyard targetCard = new TargetCardInGraveyard(0, 2, filter);
            targetCard.withNotTarget(true);
            if (!targetCard.canChoose(player.getId(), source, game) || !player.chooseTarget(Outcome.ReturnToHand, (Target)targetCard, source, game)) continue;
            Set cards = targetCard.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).collect(Collectors.toSet());
            if (!cards.isEmpty()) {
                player.moveCards(cards, Zone.HAND, source, game);
                continue;
            }
            game.informPlayers(player.getLogName() + " decided to not return anything.");
        }
        return true;
    }

    private boolean applyEmbark(Game game, Ability source) {
        game.informPlayers("'Embark' won the vote. Each player may discard their hand and draw seven cards.");
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            boolean choice = player.chooseUse(Outcome.DrawCard, "discard your hand and draw seven cards?", "", "yes", "no", source, game);
            if (choice) {
                player.discard(player.getHand().size(), false, false, source, game);
                player.drawCards(7, source, game);
                continue;
            }
            game.informPlayers(player.getLogName() + " decided to not use the 'embark' action.");
        }
        return false;
    }
}

