/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.AdventureCard;
import mage.cards.Card;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

enum SailorsBaneValue implements DynamicValue
{
    instance;

    private static final FilterCard filter;

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player player = game.getPlayer(sourceAbility.getControllerId());
        if (player == null) {
            return 0;
        }
        return game.getExile().getCardsOwned(filter, player.getId(), sourceAbility, game).size() + player.getGraveyard().count(filter, player.getId(), sourceAbility, game);
    }

    public SailorsBaneValue copy() {
        return this;
    }

    public String getMessage() {
        return "";
    }

    private static boolean checkAdventure(Card input, Game game) {
        return input instanceof AdventureCard;
    }

    static {
        filter = new FilterCard();
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate(), SailorsBaneValue::checkAdventure}));
    }
}

