/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class SakashimasWillCopyEffect
extends OneShotEffect {
    SakashimasWillCopyEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature you control. Each other creautre you control becomes a copy of that creature until end of turn";
    }

    private SakashimasWillCopyEffect(SakashimasWillCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public SakashimasWillCopyEffect copy() {
        return new SakashimasWillCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!target.canChoose(player.getId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Permanent chosenCreature = game.getPermanent(target.getFirstTarget());
        if (chosenCreature == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game)) {
            if (permanent == null || permanent.getId().equals(chosenCreature.getId())) continue;
            game.copyPermanent(Duration.EndOfTurn, chosenCreature, permanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        return true;
    }
}

