/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.RedWarriorToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class SaltRoadSkirmishEffect
extends OneShotEffect {
    SaltRoadSkirmishEffect() {
        super(Outcome.Benefit);
        this.staticText = "create two 1/1 red Warrior creature tokens. They gain haste until end of turn. Sacrifice them at the beginning of the next end step";
    }

    private SaltRoadSkirmishEffect(SaltRoadSkirmishEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaltRoadSkirmishEffect copy() {
        return new SaltRoadSkirmishEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RedWarriorToken token = new RedWarriorToken();
        token.putOntoBattlefield(2, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect("sacrifice them").setTargetPointer((TargetPointer)new FixedTargets((Token)token, game))), source);
        return true;
    }
}

