/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SamiteElderEffect
extends OneShotEffect {
    SamiteElderEffect() {
        super(Outcome.Protect);
        this.staticText = "Creatures you control gain protection from the colors of target permanent you control until end of turn";
    }

    private SamiteElderEffect(SamiteElderEffect effect) {
        super((OneShotEffect)effect);
    }

    public SamiteElderEffect copy() {
        return new SamiteElderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target != null) {
            for (ObjectColor color : target.getColor(game).getColors()) {
                FilterCard filter = new FilterCard(color.getDescription());
                filter.add((Predicate)new ColorPredicate(color));
                game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)new ProtectionAbility((Filter)filter), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES), source);
            }
            return true;
        }
        return false;
    }
}

