/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SanctuaryWallEffect
extends OneShotEffect {
    SanctuaryWallEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a stun counter on it. If you do, put a stun counter on {this}";
    }

    private SanctuaryWallEffect(SanctuaryWallEffect effect) {
        super((OneShotEffect)effect);
    }

    public SanctuaryWallEffect copy() {
        return new SanctuaryWallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null || !player.chooseUse(this.outcome, "Put a stun counter on " + permanent.getIdName() + '?', source, game) || !permanent.addCounters(CounterType.STUN.createInstance(), source, game)) {
            return false;
        }
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(p -> p.addCounters(CounterType.STUN.createInstance(), source, game));
        return true;
    }
}

