/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.s.SanctumOfAll;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SanctumOfAllTriggerEffect
extends ReplacementEffectImpl {
    SanctumOfAllTriggerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if an ability of another Shrine you control triggers while you control six or more Shrines, that ability triggers an additional time";
    }

    private SanctumOfAllTriggerEffect(SanctumOfAllTriggerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SanctumOfAllTriggerEffect copy() {
        return new SanctumOfAllTriggerEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        int numShrines;
        if (source.isControlledBy(event.getPlayerId()) && (numShrines = SanctumOfAll.count.calculate(game, source, (Effect)this)) >= 6) {
            Permanent permanent = game.getPermanent(event.getSourceId());
            return permanent != null && !permanent.getId().equals(source.getSourceId()) && permanent.hasSubtype(SubType.SHRINE, game);
        }
        return false;
    }
}

