/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SandstalkerMolochWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();
    private static final ObjectColor color = new ObjectColor("UB");

    SandstalkerMolochWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.getColor(game).shares(color)) {
            this.players.addAll(game.getOpponents(spell.getControllerId()));
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((SandstalkerMolochWatcher)game.getState().getWatcher(SandstalkerMolochWatcher.class)).players.contains(source.getControllerId());
    }
}

