/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class SandstoneOracleEffect
extends OneShotEffect {
    SandstoneOracleEffect() {
        super(Outcome.DrawCard);
        this.staticText = "choose an opponent. If that player has more cards in hand than you, draw cards equal to the difference";
    }

    private SandstoneOracleEffect(SandstoneOracleEffect effect) {
        super((OneShotEffect)effect);
    }

    public SandstoneOracleEffect copy() {
        return new SandstoneOracleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Player opponent;
            TargetOpponent target = new TargetOpponent(true);
            if (controller.choose(Outcome.DrawCard, (Target)target, source, game) && (opponent = game.getPlayer(target.getFirstTarget())) != null) {
                game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen " + opponent.getLogName());
                int cardsDiff = opponent.getHand().size() - controller.getHand().size();
                if (cardsDiff > 0) {
                    controller.drawCards(cardsDiff, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

