/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class SanwellAvengerAceEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterArtifactCard();

    SanwellAvengerAceEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top six cards of your library. You may cast a Vehicle or artifact creature spell from among them. Then put the rest on the bottom of your library in a random order";
    }

    private SanwellAvengerAceEffect(SanwellAvengerAceEffect effect) {
        super((OneShotEffect)effect);
    }

    public SanwellAvengerAceEffect copy() {
        return new SanwellAvengerAceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        SanwellAvengerAceEffect.castSpell((Cards)cards, player, source, game);
        cards.retainZone(Zone.EXILED, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    private static void castSpell(Cards cards, Player player, Ability source, Game game) {
        HashMap<UUID, List> cardMap = new HashMap<UUID, List>();
        for (Card card2 : cards.getCards(game)) {
            List castableComponents = CardUtil.getCastableComponents((Card)card2, (FilterCard)filter, (Ability)source, (Player)player, (Game)game, null, (boolean)false);
            if (castableComponents.isEmpty()) continue;
            cardMap.put(card2.getId(), castableComponents);
        }
        if (cardMap.isEmpty()) {
            return;
        }
        CardsImpl castableCards = new CardsImpl(cardMap.keySet());
        TargetCard target = new TargetCard(0, 1, Zone.ALL, filter);
        target.withNotTarget(true);
        target.withChooseHint("to cast");
        player.choose(Outcome.Benefit, (Cards)castableCards, target, source, game);
        Card cardToCast = castableCards.get(target.getFirstTarget(), game);
        if (cardToCast == null) {
            return;
        }
        List partsToCast = (List)cardMap.get(cardToCast.getId());
        if (partsToCast.isEmpty()) {
            return;
        }
        partsToCast.forEach(card -> {
            Boolean cfr_ignored_0 = (Boolean)game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), (Object)Boolean.TRUE);
        });
        SpellAbility chosenAbility = player.chooseAbilityForCast(cardToCast, game, false);
        if (chosenAbility != null) {
            player.cast(chosenAbility, game, false, new ApprovingObject(source, game));
        }
        partsToCast.forEach(card -> game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null));
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.VEHICLE.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }
}

