/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SaplingOfColfenorEffect
extends OneShotEffect {
    SaplingOfColfenorEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If it's a creature card, you gain life equal to that card's toughness, lose life equal to its power, then put it into your hand";
    }

    private SaplingOfColfenorEffect(SaplingOfColfenorEffect effect) {
        super((OneShotEffect)effect);
    }

    public SaplingOfColfenorEffect copy() {
        return new SaplingOfColfenorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Card card;
            if (controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
                CardsImpl cards = new CardsImpl(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                if (card.isCreature(game)) {
                    controller.gainLife(card.getToughness().getValue(), game, source);
                    controller.loseLife(card.getPower().getValue(), game, source, false);
                    return controller.moveCards(cards.getCards(game), Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

