/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObjectReference;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SarkhanTheDragonspeakerEffect
extends ContinuousEffectImpl {
    SarkhanTheDragonspeakerEffect() {
        super(Duration.EndOfTurn, Outcome.BecomeCreature);
        this.staticText = "Until end of turn, {this} becomes a legendary 4/4 red Dragon creature with flying, indestructible, and haste.";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private SarkhanTheDragonspeakerEffect(SarkhanTheDragonspeakerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SarkhanTheDragonspeakerEffect copy() {
        return new SarkhanTheDragonspeakerEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent != null) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.removeAllCardTypes(game);
                    permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                    permanent.removeAllSubTypes(game);
                    permanent.addSubType(game, new SubType[]{SubType.DRAGON});
                    permanent.removeAllSuperTypes(game);
                    permanent.addSuperType(game, SuperType.LEGENDARY);
                    break;
                }
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setColor(ObjectColor.RED);
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    if (sublayer != SubLayer.NA) break;
                    permanent.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                    permanent.addAbility((Ability)IndestructibleAbility.getInstance(), source.getSourceId(), game);
                    permanent.addAbility((Ability)HasteAbility.getInstance(), source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(4);
                    permanent.getToughness().setModifiedBaseValue(4);
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

