/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class SarkhansWhelpTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledPlaneswalkerPermanent filter = new FilterControlledPlaneswalkerPermanent(SubType.SARKHAN, "a Sarkhan planeswalker");

    public SarkhansWhelpTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1), false);
        this.addTarget((Target)new TargetAnyTarget());
        this.setTriggerPhrase("Whenever you activate an ability of a Sarkhan planeswalker, ");
    }

    private SarkhansWhelpTriggeredAbility(SarkhansWhelpTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SarkhansWhelpTriggeredAbility copy() {
        return new SarkhansWhelpTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return event.getPlayerId().equals(this.getControllerId()) && source != null && filter.match((Object)source, game);
    }
}

