/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SasayasEssenceManaEffect
extends ManaEffect {
    SasayasEssenceManaEffect() {
        this.staticText = "for each other land you control with the same name, add one mana of any type that land produced";
    }

    private SasayasEssenceManaEffect(SasayasEssenceManaEffect effect) {
        super((ManaEffect)effect);
    }

    public SasayasEssenceManaEffect copy() {
        return new SasayasEssenceManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        Player controller = game.getPlayer(source.getControllerId());
        Mana producedMana = (Mana)this.getValue("mana");
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && producedMana != null && permanent != null) {
            FilterLandPermanent filter = new FilterLandPermanent();
            filter.add(Predicates.not((Predicate)new PermanentIdPredicate(permanent.getId())));
            filter.add((Predicate)new NamePredicate(permanent.getName()));
            int count = game.getBattlefield().countAll((FilterPermanent)filter, controller.getId(), game);
            if (count > 0) {
                if (producedMana.getBlack() > 0) {
                    netMana.add(Mana.BlackMana((int)count));
                }
                if (producedMana.getRed() > 0) {
                    netMana.add(Mana.RedMana((int)count));
                }
                if (producedMana.getBlue() > 0) {
                    netMana.add(Mana.BlueMana((int)count));
                }
                if (producedMana.getGreen() > 0) {
                    netMana.add(Mana.GreenMana((int)count));
                }
                if (producedMana.getWhite() > 0) {
                    netMana.add(Mana.WhiteMana((int)count));
                }
                if (producedMana.getColorless() > 0) {
                    netMana.add(Mana.ColorlessMana((int)count));
                }
            }
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana newMana = new Mana();
        if (game == null) {
            return newMana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Mana mana = (Mana)this.getValue("mana");
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && mana != null && permanent != null) {
            FilterLandPermanent filter = new FilterLandPermanent();
            filter.add(Predicates.not((Predicate)new PermanentIdPredicate(permanent.getId())));
            filter.add((Predicate)new NamePredicate(permanent.getName()));
            int count = game.getBattlefield().countAll((FilterPermanent)filter, controller.getId(), game);
            if (count > 0) {
                ChoiceColor choice = new ChoiceColor(true);
                choice.getChoices().clear();
                choice.setMessage("Pick the type of mana to produce");
                if (mana.getBlack() > 0) {
                    choice.getChoices().add("Black");
                }
                if (mana.getRed() > 0) {
                    choice.getChoices().add("Red");
                }
                if (mana.getBlue() > 0) {
                    choice.getChoices().add("Blue");
                }
                if (mana.getGreen() > 0) {
                    choice.getChoices().add("Green");
                }
                if (mana.getWhite() > 0) {
                    choice.getChoices().add("White");
                }
                if (mana.getColorless() > 0) {
                    choice.getChoices().add("Colorless");
                }
                if (!choice.getChoices().isEmpty()) {
                    block18: for (int i = 0; i < count; ++i) {
                        String chosenColor;
                        choice.clearChoice();
                        if (choice.getChoices().size() == 1) {
                            chosenColor = (String)choice.getChoices().iterator().next();
                        } else if (game.inCheckPlayableState()) {
                            chosenColor = "Any";
                        } else {
                            if (!controller.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                                return newMana;
                            }
                            chosenColor = choice.getChoice();
                        }
                        switch (chosenColor) {
                            case "Black": {
                                newMana.increaseBlack();
                                continue block18;
                            }
                            case "Blue": {
                                newMana.increaseBlue();
                                continue block18;
                            }
                            case "Red": {
                                newMana.increaseRed();
                                continue block18;
                            }
                            case "Green": {
                                newMana.increaseGreen();
                                continue block18;
                            }
                            case "White": {
                                newMana.increaseWhite();
                                continue block18;
                            }
                            case "Colorless": {
                                newMana.increaseColorless();
                                continue block18;
                            }
                            case "Any": {
                                newMana.increaseAny();
                            }
                        }
                    }
                }
            }
        }
        return newMana;
    }
}

