/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.EffectKeyValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetadjustment.ThatPlayerControlsTargetAdjuster;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SatyrFiredancerTriggeredAbility
extends TriggeredAbilityImpl {
    SatyrFiredancerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)new EffectKeyValue("damage", "that much")), false);
        this.addTarget((Target)new TargetCreaturePermanent().withTargetName("target creature that player controls"));
        this.setTargetAdjuster((TargetAdjuster)new ThatPlayerControlsTargetAdjuster());
        this.setTriggerPhrase("Whenever an instant or sorcery spell you control deals damage to an opponent, ");
    }

    private SatyrFiredancerTriggeredAbility(SatyrFiredancerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SatyrFiredancerTriggeredAbility copy() {
        return new SatyrFiredancerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getControllerId(event.getSourceId()))) {
            return false;
        }
        MageObject damageSource = game.getObject(event.getSourceId());
        if (damageSource == null) {
            return false;
        }
        UUID damageTargetId = event.getTargetId();
        if (!game.getOpponents(this.getControllerId()).contains(damageTargetId)) {
            return false;
        }
        MageObject sourceObject = game.getObject(event.getSourceId());
        if (sourceObject == null || !sourceObject.isInstantOrSorcery(game)) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            effect.setTargetPointer((TargetPointer)new FixedTarget(damageTargetId));
            effect.setValue("damage", (Object)event.getAmount());
        }
        return true;
    }
}

