/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.FightTargetsEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SavageSwipeEffect
extends OneShotEffect {
    SavageSwipeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control gets +2/+2 until end of turn if its power is 2. Then it fights target creature you don't control. <i>(Each deals damage equal to its power to the other.)</i>";
    }

    private SavageSwipeEffect(SavageSwipeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SavageSwipeEffect copy() {
        return new SavageSwipeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.getPower().getValue() == 2) {
            BoostTargetEffect effect = new BoostTargetEffect(2, 2, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            game.processAction();
        }
        return new FightTargetsEffect().apply(game, source);
    }
}

