/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class SawEffect
extends OneShotEffect {
    SawEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice a permanent other than that creature or {this}. If you do, draw a card";
    }

    private SawEffect(SawEffect effect) {
        super((OneShotEffect)effect);
    }

    public SawEffect copy() {
        return new SawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("another permanent");
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        Optional.ofNullable(this.getTargetPointer().getFirst(game, source)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(MageItem::getId).map(PermanentIdPredicate::new).map(Predicates::not).ifPresent(arg_0 -> ((FilterPermanent)filter).add(arg_0));
        TargetSacrifice target = new TargetSacrifice(0, 1, filter);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.sacrifice(source, game) && player.drawCards(1, source, game) > 0;
    }
}

