/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SawInHalfEffect
extends OneShotEffect {
    SawInHalfEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target creature. If that creature dies this way, its controller creates two tokens that are copies of that creature, except their power is half that creature's power and their toughness is half that creature's toughness. Round up each time";
    }

    private SawInHalfEffect(SawInHalfEffect effect) {
        super((OneShotEffect)effect);
    }

    public SawInHalfEffect copy() {
        return new SawInHalfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || !permanent.destroy(source, game) || game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        game.processAction();
        return new CreateTokenCopyTargetEffect(permanent.getControllerId(), null, false, 2, false, false, null, SawInHalfEffect.divide(permanent.getPower()), SawInHalfEffect.divide(permanent.getToughness()), false).setSavedPermanent(permanent).apply(game, source);
    }

    private static final int divide(MageInt mageInt) {
        return Math.floorDiv(mageInt.getValue(), 2) + mageInt.getValue() % 2;
    }
}

