/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ScarecrowEffect
extends PreventionEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    ScarecrowEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false);
        this.staticText = "Prevent all damage that would be dealt to you this turn by creatures with flying";
    }

    private ScarecrowEffect(ScarecrowEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public ScarecrowEffect copy() {
        return new ScarecrowEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game) && event instanceof DamagePlayerEvent && event.getAmount() > 0) {
            Permanent permanent;
            DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
            if (event.getTargetId().equals(source.getControllerId()) && (permanent = game.getPermanentOrLKIBattlefield(damageEvent.getSourceId())) != null && filter.match((Object)permanent, game)) {
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
    }
}

