/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class ScarredPuma
extends CardImpl {
    public ScarredPuma(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{R}");
        this.subtype.add((Object)SubType.CAT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new ScarredPumaEffect()));
    }

    private ScarredPuma(ScarredPuma card) {
        super((CardImpl)card);
    }

    public ScarredPuma copy() {
        return new ScarredPuma(this);
    }

    static class ScarredPumaEffect
    extends RestrictionEffect {
        private final FilterAttackingCreature filter = new FilterAttackingCreature();

        public ScarredPumaEffect() {
            super(Duration.WhileOnBattlefield);
            this.staticText = "{this} can't attack unless a black or green creature also attacks";
        }

        private ScarredPumaEffect(ScarredPumaEffect effect) {
            super((RestrictionEffect)effect);
        }

        public ScarredPumaEffect copy() {
            return new ScarredPumaEffect(this);
        }

        public boolean canAttackCheckAfter(int numberOfAttackers, Ability source, Game game, boolean canUseChooseDialogs) {
            return false;
        }

        public boolean applies(Permanent permanent, Ability source, Game game) {
            if (permanent.getId().equals(source.getSourceId())) {
                for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)this.filter, source.getControllerId(), source, game)) {
                    ObjectColor color;
                    if (Objects.equals(creature.getId(), source.getSourceId()) || !(color = creature.getColor(game)).isBlack() && !color.isGreen()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

