/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfMainPhaseDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.abilities.effects.mana.AddManaToManaPoolSourceControllerEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class ScatteringStrokeEffect
extends OneShotEffect {
    ScatteringStrokeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. Clash with an opponent. If you win, at the beginning of your next main phase, you may add an amount of {C} equal to that spell's mana value";
    }

    private ScatteringStrokeEffect(ScatteringStrokeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScatteringStrokeEffect copy() {
        return new ScatteringStrokeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = (Spell)game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && spell != null) {
            game.getStack().counter(spell.getId(), source, game);
            if (new ClashEffect().apply(game, source)) {
                AddManaToManaPoolSourceControllerEffect effect = new AddManaToManaPoolSourceControllerEffect(new Mana(0, 0, 0, 0, 0, 0, 0, spell.getManaValue()));
                AtTheBeginOfMainPhaseDelayedTriggeredAbility delayedAbility = new AtTheBeginOfMainPhaseDelayedTriggeredAbility((Effect)effect, true, TargetController.YOU, AtTheBeginOfMainPhaseDelayedTriggeredAbility.PhaseSelection.NEXT_MAIN);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }
}

