/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldWithCounterTargetEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ScavengersTalentEffect
extends OneShotEffect {
    ScavengersTalentEffect() {
        super(Outcome.Benefit);
        this.staticText = "return a creature card from your graveyard to the battlefield with a finality counter on it";
    }

    private ScavengersTalentEffect(ScavengersTalentEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScavengersTalentEffect copy() {
        return new ScavengersTalentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        return new ReturnFromGraveyardToBattlefieldWithCounterTargetEffect(new Counter[]{CounterType.FINALITY.createInstance()}).setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game)).apply(game, source);
    }
}

