/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SchemingFenceDisableEffect
extends ContinuousRuleModifyingEffectImpl {
    SchemingFenceDisableEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "activated abilities of the chosen permanent can't be activated";
    }

    private SchemingFenceDisableEffect(SchemingFenceDisableEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SchemingFenceDisableEffect copy() {
        return new SchemingFenceDisableEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        MageObjectReference chosenPermanentMOR = (MageObjectReference)game.getState().getValue(sourcePermanent.getId() + "_chosenPermanent");
        if (chosenPermanentMOR == null) {
            return false;
        }
        return Optional.ofNullable(chosenPermanentMOR).map(MageObjectReference.class::cast).filter(mor -> mor.zoneCounterIsCurrent(game)).map(MageObjectReference::getSourceId).map(uuid -> uuid.equals(event.getSourceId())).orElse(false);
    }
}

