/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SchemingFenceGainEffect
extends ContinuousEffectImpl {
    SchemingFenceGainEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of the chosen permanent except for loyalty abilities.";
    }

    private SchemingFenceGainEffect(SchemingFenceGainEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SchemingFenceGainEffect copy() {
        return new SchemingFenceGainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        MageObjectReference chosenPermanentMOR = (MageObjectReference)game.getState().getValue(source.getSourceId() + "_chosenPermanent");
        if (chosenPermanentMOR == null) {
            return false;
        }
        Permanent chosenPermanent = Optional.ofNullable(chosenPermanentMOR).map(MageObjectReference.class::cast).map(mor -> mor.getPermanent(game)).orElse(null);
        if (chosenPermanent == null) {
            return false;
        }
        for (Ability ability : chosenPermanent.getAbilities(game).getActivatedAbilities(Zone.ALL)) {
            if (ability instanceof LoyaltyAbility) continue;
            Ability copied = ability.copy();
            ability.getEffects().setValue("schemingFence", (Object)source.getSourceId());
            permanent.addAbility(copied, source.getSourceId(), game, true);
        }
        return true;
    }
}

