/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ScholarshipSponsorEffect
extends OneShotEffect {
    ScholarshipSponsorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player who controls fewer lands than the player who controls the most lands searches their library for a number of basic land cards less than or equal to the difference, puts those cards onto the battlefield tapped, then shuffles";
    }

    private ScholarshipSponsorEffect(ScholarshipSponsorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ScholarshipSponsorEffect copy() {
        return new ScholarshipSponsorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Map playerMap = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game).stream().map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        int maxValue = playerMap.values().stream().mapToInt(x -> x).max().orElse(0);
        if (maxValue < 1) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            int diff = maxValue - playerMap.getOrDefault(playerId, 0);
            if (player == null || diff < 1) continue;
            TargetCardInLibrary target = new TargetCardInLibrary(diff, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
            player.searchLibrary(target, source, game);
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            cards.retainZone(Zone.LIBRARY, game);
            player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

