/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ScionOfDracoEffect
extends ContinuousEffectImpl {
    ScionOfDracoEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.staticText = "each creature you control has vigilance if it's white, hexproof if it's blue, lifelink if it's black, first strike if it's red, and trample if it's green";
        this.addDependencyType(DependencyType.AddingAbility);
    }

    private ScionOfDracoEffect(ScionOfDracoEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ScionOfDracoEffect copy() {
        return new ScionOfDracoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            ObjectColor color = permanent.getColor(game);
            if (color.isWhite()) {
                permanent.addAbility((Ability)VigilanceAbility.getInstance(), source.getSourceId(), game);
            }
            if (color.isBlue()) {
                permanent.addAbility((Ability)HexproofAbility.getInstance(), source.getSourceId(), game);
            }
            if (color.isBlack()) {
                permanent.addAbility((Ability)LifelinkAbility.getInstance(), source.getSourceId(), game);
            }
            if (color.isRed()) {
                permanent.addAbility((Ability)FirstStrikeAbility.getInstance(), source.getSourceId(), game);
            }
            if (!color.isGreen()) continue;
            permanent.addAbility((Ability)TrampleAbility.getInstance(), source.getSourceId(), game);
        }
        return true;
    }
}

