/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.SearchEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class ScionOfTheUrDragonEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterPermanentCard("Dragon permanent card");

    public ScionOfTheUrDragonEffect() {
        super(new TargetCardInLibrary(filter), Outcome.Copy);
        this.staticText = "Search your library for a Dragon permanent card and put it into your graveyard. If you do, {this} becomes a copy of that card until end of turn. Then shuffle.";
    }

    private ScionOfTheUrDragonEffect(ScionOfTheUrDragonEffect effect) {
        super((SearchEffect)effect);
    }

    public ScionOfTheUrDragonEffect copy() {
        return new ScionOfTheUrDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            if (player.searchLibrary(this.target, source, game)) {
                for (UUID cardId : this.target.getTargets()) {
                    Card card = player.getLibrary().getCard(cardId, game);
                    if (card == null) continue;
                    player.moveCards(card, Zone.GRAVEYARD, source, game);
                    CopyEffect copyEffect = new CopyEffect(Duration.EndOfTurn, (MageObject)card, source.getSourceId());
                    game.addEffect((ContinuousEffect)copyEffect, source);
                }
            }
            player.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.DRAGON.getPredicate());
    }
}

