/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ScoriaWurmEffect
extends OneShotEffect {
    ScoriaWurmEffect() {
        super(Outcome.Damage);
        this.staticText = "flip a coin. If you lose the flip, return {this} to its owner's hand";
    }

    private ScoriaWurmEffect(ScoriaWurmEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            if (controller.flipCoin(source, game, true)) {
                return true;
            }
            new ReturnToHandSourceEffect().apply(game, source);
            return true;
        }
        return false;
    }

    public ScoriaWurmEffect copy() {
        return new ScoriaWurmEffect(this);
    }
}

