/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ScouringSandsDamageEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature your opponents control");

    public ScouringSandsDamageEffect() {
        super(Outcome.GainLife);
        this.staticText = "{this} deals 1 damage to each creature your opponents control";
    }

    private ScouringSandsDamageEffect(ScouringSandsDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            if (creature == null) continue;
            creature.damage(1, source.getSourceId(), source, game, false, false);
        }
        return true;
    }

    public ScouringSandsDamageEffect copy() {
        return new ScouringSandsDamageEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

